% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{factor_plot}
\alias{factor_plot}
\title{Get plot with factor analysis result}
\usage{
factor_plot(
  data,
  cols,
  newcols = NULL,
  k = 2,
  method = "pca",
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe.}

\item{cols}{A tidy selection of item columns.
If the first column already contains a pca from add_factors, the result is used. Other parameters are ignored.
If there is no pca result yet, it is calculated by \link{add_factors} first.}

\item{newcols}{Names of the factor columns as a character vector.
Must be the same length as k or NULL.
Set to NULL (default) to automatically build a name
from the common column prefix, prefixed with "fct_", postfixed with the factor number.}

\item{k}{Number of factors to calculate.
Set to NULL to generate a scree plot with eigenvalues for all components up to the number of items
and automatically choose k. Eigenvalues and the decision on k are calculated by
\code{psych::\link[psych:fa.parallel]{fa.parallel}}.}

\item{method}{The method as character value. Currently, only pca is supported.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_metrics}.}
}
\value{
A ggplot object.
}
\description{
PCA is performed using \link{add_factors}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
ds <- volker::chatgpt

volker::factor_plot(ds, starts_with("cg_adoption"), k = 3)
}
\keyword{internal}
