% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_stock_prices.R
\name{download_data_stock_prices}
\alias{download_data_stock_prices}
\title{Download Stock Data}
\usage{
download_data_stock_prices(symbols, start_date = NULL, end_date = NULL)
}
\arguments{
\item{symbols}{A character vector of stock symbols to download data for. At least one
symbol must be provided.}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, a subset of the dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, a subset of the dataset is returned.}
}
\value{
A tibble containing the downloaded stock data with columns: symbol,
date, volume, open, low, high, close, and adjusted_close.
}
\description{
Downloads historical stock data from Yahoo Finance for given symbols and date range.
}
\examples{
\donttest{
  download_data_stock_prices(c("AAPL", "MSFT"))
  download_data_stock_prices("GOOGL", "2021-01-01", "2022-01-01" )
}
}
