% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkpd_assist.R
\name{format_pars}
\alias{format_pars}
\title{Format parameters for use in Rcpp functions

Order parameters for 1-4 compartment models to be used in Rcpp functions in
predict_pkmod method.}
\usage{
format_pars(pars, ncmpt = 3)
}
\arguments{
\item{pars}{Vector of named parameters. Names can be capitalized or lowercase
and can include variations of "V1" as "V" or clearance terms rather than
elimination rate constants.}

\item{ncmpt}{Number of compartments in the model. This should be a value
between 1 and 4. If ncmpt = 4, it assumes that the fourth compartment is an
effect-site without a corresponding volume parameter.}
}
\value{
Numeric vector of transformed parameter values.
}
\description{
Format parameters for use in Rcpp functions

Order parameters for 1-4 compartment models to be used in Rcpp functions in
predict_pkmod method.
}
\examples{
format_pars(c(V1 = 8.9, CL = 1.4, q2 = 0.9, v2 = 18), ncmpt = 2)
format_pars(c(V1 = 8.9, CL = 1.4, q2 = 0.9, v2 = 18, cl2 = 3), ncmpt = 2)
}
