% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round.R
\name{round}
\alias{round}
\alias{ceiling}
\alias{floor}
\alias{trunc}
\alias{signif}
\alias{ceiling.data.frame}
\alias{floor.data.frame}
\alias{trunc.data.frame}
\alias{round.data.frame}
\alias{signif.data.frame}
\title{Rounding Numbers for Data Frames}
\usage{
\method{ceiling}{data.frame}(x)

\method{floor}{data.frame}(x)

\method{trunc}{data.frame}(x, ...)

\method{round}{data.frame}(x, digits = 0)

\method{signif}{data.frame}(x, digits = 6)
}
\arguments{
\item{x}{a data.frame with numeric columns.}

\item{...}{arguments to be passed to methods.}

\item{digits}{integer indicating the number of decimal places (\code{round})
or significant digits (\code{signif}) to be used. See \code{\link[base]{round}} for 
more details.}
}
\description{
Rounds numeric columns in data.frames
}
\details{
Takes a data.frame and returns a data.frame with the specified function 
  applied to each numeric column.
}
\examples{
data(mtcars)

round(mtcars, 0)

signif(mtcars, 2)

}
\seealso{
\code{\link[base]{Round}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
