% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_modern.R
\name{theme_modern}
\alias{theme_modern}
\title{The easystats' minimal theme}
\usage{
theme_modern(
  base_size = 11,
  base_family = "",
  plot.title.size = 1.35 * base_size,
  plot.title.face = "plain",
  plot.title.space = 1.8 * base_size,
  plot.title.position = "plot",
  legend.position = "right",
  axis.title.space = 1.8 * base_size,
  legend.title.size = 1.2 * base_size,
  legend.text.size = 1.1 * base_size,
  axis.title.size = 1.2 * base_size,
  axis.title.face = "plain",
  axis.text.size = 1.1 * base_size,
  axis.text.angle = NULL,
  tags.size = 1.35 * base_size,
  tags.face = "bold",
  show.ticks = FALSE,
  ...
)
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{plot.title.size}{Title size in pts. Can be "none".}

\item{plot.title.face}{Title font face ("plain", "italic", "bold", "bold.italic").}

\item{plot.title.space}{Title spacing.}

\item{plot.title.position}{Alignment of the plot title/subtitle and caption.
The setting for plot.title.position applies to both the title and the
subtitle. A value of "panel" (the default) means that titles and/or caption
are aligned to the plot panels. A value of "plot" means that titles and/or
caption are aligned to the entire plot (minus any space for margins and
plot tag).}

\item{legend.position}{the default position of legends ("none", "left",
"right", "bottom", "top", "inside")}

\item{axis.title.space}{Axis title spacing.}

\item{legend.title.size}{Legend elements text size in pts.}

\item{legend.text.size}{Legend elements text size in pts. Can be "none".}

\item{axis.title.size}{Axis title text size in pts.}

\item{axis.title.face}{Axis font face ("plain", "italic", "bold", "bold.italic").}

\item{axis.text.size}{Axis text size in pts.}

\item{axis.text.angle}{Rotate  the x axis labels.}

\item{tags.size}{Tags text size in pts.}

\item{tags.face}{Tags font face ("plain", "italic", "bold", "bold.italic").}

\item{show.ticks}{Logical, if \code{TRUE}, adds inner tick marks to the plot and
slightly increases the padding between axis and the related labels.}

\item{...}{Further arguments passed to \code{ggplot2::theme()}.}
}
\description{
A modern, sleek and elegant theme for ggplot.
}
\note{
Base elements like plot borders, titles etc. are scaling with
\code{base_size}, i.e. when \code{base_size} is increased, all other relevant elements
are increased in proportion to the base size, to ensure proper scaling of
the plot. Set arguments for the related elements explicitly to define custom
sizes.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Sepal.Width, y = Sepal.Length, color = Species)) +
  geom_point() +
  scale_color_see() +
  theme_modern()

# for a slightly better orientation, tick marks can be added
ggplot(iris, aes(x = Sepal.Width, y = Sepal.Length, color = Species)) +
  geom_point() +
  scale_color_see() +
  theme_modern(show.ticks = TRUE)
}
