% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_colorhex.R
\name{palette_colorhex}
\alias{palette_colorhex}
\title{Color palettes from \url{https://www.color-hex.com/}}
\usage{
palette_colorhex(palette = 1014416, reverse = FALSE, ...)
}
\arguments{
\item{palette}{The numeric code for a palette at \url{https://www.color-hex.com/}.
For example, \code{1014416} for the
\href{https://www.color-hex.com/color-palette/1014416}{Josiah color palette (number 1014416)}.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
This function downloads a requested color palette from \url{https://www.color-hex.com/}.
This website provides a large number of user-submitted color palettes.
}
\details{
This function is usually not called directly, but from within
\code{\link[=scale_color_colorhex]{scale_color_colorhex()}}.
}
\note{
The default \href{https://www.color-hex.com/color-palette/1014416}{Josiah color palette (number 1014416)}
is available without an internet connection. All other color palettes require
an internet connection to download and access.
}
