% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikCauchy}
\alias{llikCauchy}
\title{log likelihood of Cauchy distribution and it's derivatives (from stan)}
\usage{
llikCauchy(x, location = 0, scale = 1, full = FALSE)
}
\arguments{
\item{x}{Observation}

\item{location, scale}{location and scale parameters.}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the log pdf value of with
\code{dLocation} and \code{dScale} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
log likelihood of Cauchy distribution and it's derivatives (from stan)
}
\details{
In an \code{rxode2()} model, you can use \code{llikCauchy()} but you have to
use all arguments.  You can also get the derivative of \code{location} and \code{scale} with
\code{llikCauchyDlocation()} and \code{llikCauchyDscale()}.
}
\examples{
\donttest{
x <- seq(-3, 3, length.out = 21)

llikCauchy(x, 0, 1)

llikCauchy(x, 3, 1, full=TRUE)

et <- et(-3, 3, length.out=10)
et$location <- 0
et$scale <- 1

model <- function() {
  model({
    fx <- llikCauchy(time, location, scale)
    dLocation <- llikCauchyDlocation(time, location, scale)
    dScale <- llikCauchyDscale(time, location, scale)
  })
}

rxSolve(model, et)
}
}
\author{
Matthew L. Fidler
}
