#' File I/O for profile data
#'
#' @description
#' `read_pprof()` reads a file generated by `pprof -proto`, `write_pprof()`
#' writes a Gzip-compressed file that can be processed with `pprof`.
#'
#' @details
#' Use the \pkg{proftools}, \pkg{profvis}, or \pkg{prof.tree} R packages to
#' further analyze files created by the `write_rprof()` function.
#'
#' @return
#' Valid profile data (readers), input data (writers).
#'
#' @export
#' @rdname read_rprof
#' @include rprof-read.R
read_pprof <- function(path, ..., version = "1.0") {
  stopifnot(version == get_default_meta()$value)
  msg <- read_msg(path)
  ds <- msg_to_ds(msg)
  validate_profile(ds)
  ds
}

read_msg <- function(path) {
  provide_proto()

  con <- gzfile(path, "rb")
  defer(close(con))
  RProtoBuf::read(perftools.profiles.Profile, con)
}
