% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerscale_sensitivity.R
\name{powerscale-sensitivity}
\alias{powerscale-sensitivity}
\alias{powerscale_sensitivity}
\alias{powerscale_sensitivity.default}
\alias{powerscale_sensitivity.priorsense_data}
\alias{powerscale_sensitivity.CmdStanFit}
\alias{powerscale_sensitivity.stanfit}
\title{Power-scaling sensitivity analysis}
\usage{
powerscale_sensitivity(x, ...)

\method{powerscale_sensitivity}{default}(
  x,
  variable = NULL,
  lower_alpha = 0.99,
  upper_alpha = 1.01,
  div_measure = "cjs_dist",
  measure_args = list(),
  component = c("prior", "likelihood"),
  sensitivity_threshold = 0.05,
  moment_match = FALSE,
  k_threshold = 0.5,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  prior_selection = NULL,
  likelihood_selection = NULL,
  log_prior_name = "lprior",
  log_lik_name = "log_lik",
  num_args = NULL,
  ...
)

\method{powerscale_sensitivity}{priorsense_data}(
  x,
  variable = NULL,
  lower_alpha = 0.99,
  upper_alpha = 1.01,
  div_measure = "cjs_dist",
  measure_args = list(),
  component = c("prior", "likelihood"),
  sensitivity_threshold = 0.05,
  moment_match = FALSE,
  k_threshold = 0.5,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  prior_selection = NULL,
  likelihood_selection = NULL,
  num_args = NULL,
  ...
)

\method{powerscale_sensitivity}{CmdStanFit}(x, ...)

\method{powerscale_sensitivity}{stanfit}(x, ...)
}
\arguments{
\item{x}{Model fit object or priorsense_data object.}

\item{...}{Further arguments passed to functions.}

\item{variable}{Character vector of variables to check.}

\item{lower_alpha}{Lower alpha value for gradient calculation.}

\item{upper_alpha}{Upper alpha value for gradient calculation.}

\item{div_measure}{Character (case sensitive) specifying the
divergence measure to use. The following methods are
implemented:
\itemize{
\item \code{"cjs_dist"}: Cumulative Jensen-Shannon distance. Default
method. See function \code{cjs_dist} for more details.
\item \code{"js_dist"}: Jensen-Shannon distance.
\item \code{"js_div"}: Jensen-Shannon divergence.
\item \code{"hellinger_dist"}: Hellinger distance.
\item \code{"kl_dist"}: Kullback-Leibler distance.
\item \code{"kl_div"}: Kullback-Leibler divergence.
\item \code{"ks_dist"}: Kolmogorov-Smirnov distance.
\item \code{"hellinger_dist"}: Hellinger distance.
\item \code{"ws_dist"}: Wassterstein distance (pass \code{measure_args = list(p = N)})
for a different order, where N is the order.
}}

\item{measure_args}{Named list of further arguments passed to divergence measure functions.}

\item{component}{Character vector specifying component(s) to scale
(default is both "prior" and "likelihood").}

\item{sensitivity_threshold}{Threshold for flagging variable as
sensitive to power-scaling.}

\item{moment_match}{Logical; Indicate whether or not moment
matching should be performed. Can only be TRUE if \code{is_method} is
"psis".}

\item{k_threshold}{Threshold value for Pareto k values above which
the moment matching algorithm is used. Default is 0.5.}

\item{resample}{Logical; Indicate whether or not draws should be
resampled based on calculated importance weights.}

\item{transform}{Indicate a transformation of posterior draws to
perform before sensitivity analysis. Either "scale" or "whiten".}

\item{prediction}{Function taking the model fit and returning a
draws_df of predictions to be appended to the posterior draws}

\item{prior_selection}{Vector specifying partitions of component to be
included in power-scaling. Default is NULL, which takes all
partitions. If this is a character, then it is appended to the
variable name (specified by \code{log_prior_name}) with an \verb{_}
between them. If numeric, then it is appended inside \verb{[]}.}

\item{likelihood_selection}{Vector specifying partitions of component to be
included in power-scaling. Default is NULL, which takes all
partitions. If this is a character, then it is appended to the
variable name (specified by \code{log_lik_name}) with an \verb{_}
between them. If numeric, then it is appended inside \verb{[]}.}

\item{log_prior_name}{Character (case sensitive) specifying name of the variable storing the log prior evaluations}

\item{log_lik_name}{Character (case sensitive) specifying name of the variable storing the log likelihood evaluations}

\item{num_args}{(named list) Optional arguments passed to
\link[tibble:num]{num()} for pretty printing of summaries. Can be
controlled globally via the \code{posterior.num_args}
\link[base:options]{option}.}
}
\value{
Table of sensitivity values for each specified variable.
}
\description{
Calculates the prior/likelihood sensitivity based on power-scaling
perturbations. This is done using importance sampling (and
optionally moment matching).
}
\examples{
ex <- example_powerscale_model()
powerscale_sensitivity(ex$draws)
}
\references{
Kallioinen, N., Paananen, T., Bürkner, P-C., Vehtari, A. (2023).
Detecting and diagnosing prior and likelihood sensitivity with
power-scaling perturbations.  \emph{Statistics and
Computing}. 34(57).  \code{doi:10.1007/s11222-023-10366-5}

Vehtari, A., Simpson, D., Gelman, A., Yao, Y., and Gabry,
J. (2024).  Pareto smoothed importance sampling. \emph{Journal of
Machine Learning Research}. 25(72).
\code{https://jmlr.org/papers/v25/19-556.html}

Paananen, T., Piironen, J., Bürkner, P-C., Vehtari, A. (2021).
Implicitly adaptive importance sampling.  \emph{Statistics and
Computing}. 31(16).  \code{doi:10.1007/s11222-020-09982-2}
}
