% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_string.R
\name{by_split}
\alias{by_split}
\title{Applying a parser to a split string}
\usage{
by_split(p, split, finish = TRUE, fixed = FALSE, perl = FALSE)
}
\arguments{
\item{p}{A parser.}

\item{split}{a string (or object which can be coerced to such) containing
\link{regular expression}(s) (unless fixed = TRUE) to use for splitting.
If empty matches occur, in particular if split has length 0, x is split
into single characters.}

\item{finish}{logical. Should the parser completely consume the string?
Defaults to \code{TRUE}.}

\item{fixed}{
    logical.  If \code{TRUE} match \code{split} exactly, otherwise
    use regular expressions.  Has priority over \code{perl}.
  }

\item{perl}{logical.  Should Perl-compatible regexps be used?}
}
\value{
A parser.
}
\description{
Splits a string by using a split pattern and then applies the parser \code{p}
to the resulting character vector. If \code{finish = TRUE} then the parser should
completely consume its input, otherwise the parser fails. If
\code{finish = FALSE} then any remaining part of the string is discarded.
}
\details{
The function \code{\link[base:strsplit]{base::strsplit()}} is used to perform the splitting. The
parameters \code{split}, \code{fixed} and \code{perl} are passed on to that function.
}
\examples{
by_split((literal("a") \%then\% literal("b")),"\\\\t") ("a\tb") # success
by_split((literal("a") \%then\% literal("b")),"\\\\t") ("a\tb\tc") # failure
by_split((literal("a") \%then\% literal("b")),"\\\\t", finish=FALSE) ("a\tb\tc") # success
}
\seealso{
\code{\link[base:strsplit]{base::strsplit()}}, \code{\link[=by_symbol]{by_symbol()}}
}
