% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calcVarExpPerComponent}
\alias{calcVarExpPerComponent}
\title{Calculate the variance explained of a PARAFAC model, per component}
\usage{
calcVarExpPerComponent(Fac, X)
}
\arguments{
\item{Fac}{Fac object output of a model}

\item{X}{Input dataset}
}
\value{
Vector of scalars of the percentage of variation explained per component
}
\description{
Calculate the variance explained of a PARAFAC model, per component
}
\examples{
X = array(rnorm(108*100*10), c(108,100,10))
model = parafac(X, 2)
calcVarExpPerComponent(model$Fac, X)
}
