% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.textmodel_newsmap}
\alias{predict.textmodel_newsmap}
\title{Prediction method for textmodel_newsmap}
\usage{
\method{predict}{textmodel_newsmap}(
  object,
  newdata = NULL,
  confidence = FALSE,
  rank = 1L,
  type = c("top", "all"),
  rescale = FALSE,
  min_conf = -Inf,
  min_n = 0L,
  ...
)
}
\arguments{
\item{object}{a fitted Newsmap textmodel.}

\item{newdata}{dfm on which prediction should be made.}

\item{confidence}{if \code{TRUE}, it returns likelihood ratio score.}

\item{rank}{rank of the class to be predicted. Only used when \code{type = "top"}.}

\item{type}{if \code{top}, returns the most likely class specified by \code{rank};
otherwise return a matrix of likelihood ratio scores for all possible
classes.}

\item{rescale}{if \code{TRUE}, likelihood ratio scores are normalized using \code{\link[=scale]{scale()}}. This affects
both types of results.}

\item{min_conf}{return \code{NA} when confidence is lower than this value.}

\item{min_n}{set the minimum number of polarity words in documents.}

\item{...}{not used.}
}
\description{
Predict document class using trained a Newsmap model
}
