% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_errors.R
\name{calculate_errors}
\alias{calculate_errors}
\title{Calculate error (standard error or 95\%CI) in elements of a matrix population
model.}
\usage{
calculate_errors(mat_U, mat_F, sample_size, type = "sem", calculate_A = TRUE)
}
\arguments{
\item{mat_U}{matrix of mean survival probabilities}

\item{mat_F}{matrix of mean fecundity values}

\item{sample_size}{either (1) a single matrix of sample sizes for each
element of the MPM, (2) a list of two named matrices ("\code{mat_F_ss}",
"\code{mat_U_ss}") containing sample sizes for the survival and fecundity
submatrices of the MPM or (3) a single value applied to the whole matrix}

\item{type}{A character string indicating the type of error to calculate.
Must be one of "\code{sem}" (standard error), or "\code{CI95}" (95\% confidence
interval).}

\item{calculate_A}{A logical argument indicating whether the returned error
information should include the A matrix and its error. Defaults to \code{TRUE}.}
}
\value{
A list containing the original matrices and the error estimates (or
upper and lower confidence intervals) for the U, F and (optionally) A
matrices.
}
\description{
Given two submatrices of a matrix population model (\code{mat_U} and \code{mat_F}, the
growth/survival matrix and the fecundity matrix respectively) and a sample
size, or matrix/matrices of sample sizes, this function calculates the
standard error or 95\% confidence interval (95\%CI) for each element of the
matrix. These calculations assume that \code{mat_U} is the result of binomial
processes (i.e., the survival (0/1) of a sample of n individuals), while
\code{mat_F} is the result of Poisson processes (i.e., counts of offspring from n
individuals), where n is the sample size.
}
\details{
The output is a list containing the original matrices and matrices showing
error estimates or confidence intervals.
}
\examples{
# Set up two submatrices
matU <- matrix(c(
  0.1, 0,
  0.2, 0.4
), byrow = TRUE, nrow = 2)
matF <- matrix(c(
  0, 4,
  0., 0.
), byrow = TRUE, nrow = 2)

# errors as 95\% CI, with a sample size of 20 for all elements
calculate_errors(mat_U = matU, mat_F = matF, sample_size = 20, type = "CI95")

# errors as sem, with a sample size of 20 for all elements
calculate_errors(mat_U = matU, mat_F = matF, sample_size = 20, type = "sem")

# Sample size is a single matrix applied to both F and U matrices
ssMat <- matrix(10, nrow = 2, ncol = 2)

calculate_errors(
  mat_U = matU, mat_F = matF, sample_size = ssMat, type =
    "sem"
)

# Sample size is a list of two matrices, one for F and one for U.
ssMats <- list(
  "mat_F_ss" = matrix(10, nrow = 2, ncol = 2),
  "mat_U_ss" = matrix(10, nrow = 2, ncol = 2)
)
calculate_errors(
  mat_U = matU, mat_F = matF, sample_size = ssMats, type =
    "sem"
)

}
\seealso{
\code{\link[=add_mpm_error]{add_mpm_error()}} which simulates matrices with known values and
sample sizes.

Other errors: 
\code{\link{add_mpm_error}()},
\code{\link{compute_ci}()},
\code{\link{compute_ci_U}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{errors}
