% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_functions.R
\name{orbi_calculate_summarized_ratio}
\alias{orbi_calculate_summarized_ratio}
\title{Calculate isotopocule ratio}
\usage{
orbi_calculate_summarized_ratio(
  numerator,
  denominator,
  ratio_method = c("direct", "mean", "sum", "median", "geometric_mean", "slope",
    "weighted_sum")
)
}
\arguments{
\item{numerator}{Column(s) used as numerator; contains ion counts}

\item{denominator}{Column used as denominator; contains ion counts}

\item{ratio_method}{Method for computing the ratio. \strong{Please note well}: the formula used to calculate ion ratios matters! Do not simply use arithmetic mean. The best option may depend on the type of data you are processing (e.g., MS1 versus M+1 fragmentation). \code{ratio_method} can be one of the following:
\itemize{
\item \code{mean}: arithmetic mean of ratios from individual scans.
\item \code{sum}: sum of all ions of the numerator across all scans divided by the sum of all ions observed for the denominator across all scans.
\item \code{geometric_mean}: geometric mean of ratios from individual scans.
\item \code{slope}: The ratio is calculated using the slope obtained from a linear regression model that is weighted by the \verb{numerator x}, using \code{stats::lm(x ~ y + 0, weights = x)}.
\item \code{weighted_sum}: A derivative of the \code{sum} option. The weighing function ensures that each scan contributes equal weight to the ratio calculation,
i.e. scans with more ions in the Orbitrap do not contribute disproportionately to the total \code{sum} of \code{x} and \code{y} that is used to calculate \code{x/y}.
}}
}
\value{
Single value ratio between the isotopocules defined as \code{numerator} and \code{denominator} calculated using the \code{ratio_method}.
}
\description{
This function calculates the ratio of two isotopocules (the \code{numerator} and \code{denominator}). This function averages multiple measurements of each using the \code{ratio_method} and returns a single value. Normally this function is not called directly by the user, but via the function \code{\link[=orbi_summarize_results]{orbi_summarize_results()}}, which calculates isotopocule ratios and other results for an entire dataset.
}
\examples{
df <-
  system.file("extdata", "testfile_flow.isox", package = "isoorbi") |>
  orbi_read_isox()

ions_18O <- dplyr::filter(df, isotopocule == "18O")$ions.incremental
ions_M0 <- dplyr::filter(df, isotopocule == "M0")$ions.incremental

orbi_calculate_summarized_ratio(
  numerator = ions_18O, denominator = ions_M0, ratio_method = "sum"
)

orbi_calculate_summarized_ratio(
  numerator = ions_18O, denominator = ions_M0, ratio_method = "slope"
)

}
