% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{height}
\alias{height}
\alias{height<-}
\alias{set_height}
\title{Set the table height}
\usage{
height(ht)

height(ht) <- value

set_height(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A number or string. Set to \code{NA} to reset to the default, which is \code{NA_real_}.}
}
\value{
\code{property()} returns the property value(s).
\code{set_property()} and \code{map_property()} return the modified huxtable.
}
\description{
\code{height()} sets the height of the entire table, while \code{\link[=row_height]{row_height()}} sets the
height of individual rows. A numeric height is treated as a proportion of
the containing block (HTML) or \verb{\\textheight} (LaTeX). A character height
must be a valid CSS or LaTeX dimension.
}
\examples{
set_height(jams, 0.4)

}
\seealso{
Other table measurements: 
\code{\link{col_width}()},
\code{\link{row_height}()},
\code{\link{width}()}
}
\concept{table measurements}
