% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_dcsbm.R
\docType{class}
\name{DcSbm}
\alias{DcSbm}
\alias{DcSbmPrior-class}
\alias{DcSbm-class}
\alias{DcSbmPrior}
\title{Degree Corrected Stochastic Block Model Prior class}
\usage{
DcSbmPrior(p = NaN, type = "guess")

DcSbm(alpha = 1, p = NaN, type = "guess")
}
\arguments{
\item{p}{Exponential prior parameter (default to NaN, in this case p will be estimated from data as the mean connection probability)}

\item{type}{define the type of networks (either "directed", "undirected" or "guess", default to "guess")}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{DcSbmPrior-class} object

a \code{DcSbm-class} object
}
\description{
An S4 class to represent a Degree Corrected Stochastic Block Model.
Such model can be used to cluster graph vertex, and model a square adjacency matrix \eqn{X} with the following generative model :
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{kl} \sim Exponential(p)}
\deqn{ \gamma_i^+,\gamma_i^- \sim \mathcal{U}(S_k)}
\deqn{ X_{ij}|Z_{ik}Z_{jl}=1 \sim \mathcal{P}(\gamma_i^+\theta_{kl}\gamma_j^-)}
The individuals parameters \eqn{\gamma_i^+,\gamma_i^-} allow to take into account the node degree heterogeneity.
These parameters have uniform priors over the simplex \eqn{S_k} ie. \eqn{\sum_{i:z_{ik}=1}\gamma_i^+=1}.
These classes mainly store the prior parameters value \eqn{\alpha,p} of this generative model.
The \code{DcSbm-class} must be used when fitting a simple Degree Corrected Stochastic Block Model whereas the \code{DcSbmPrior-class} must be used when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
DcSbmPrior()
DcSbmPrior(type = "undirected")
DcSbm()
DcSbm(type = "undirected")
}
\seealso{
\code{\link{DcSbmFit-class}}, \code{\link{DcSbmPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Gmm}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
