% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_bar_interactive.R,
%   R/geom_col_interactive.R
\name{geom_bar_interactive}
\alias{geom_bar_interactive}
\alias{geom_col_interactive}
\title{Create interactive bars}
\usage{
geom_bar_interactive(...)

geom_col_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \link{interactive_parameters}.}
}
\description{
The geometries are based on \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}
and \code{\link[ggplot2:geom_bar]{ggplot2::geom_col()}}.
See the documentation for those functions for more details.
}
\section{Details for interactive geom functions}{

The interactive parameters can be supplied with two ways:
\itemize{
\item As aesthetics with the mapping argument (via \code{\link[ggplot2:aes]{ggplot2::aes()}}).
In this way they can be mapped to data columns and apply to a set of geometries.

\item As plain arguments into the geom_*_interactive function.
In this way they can be set to a scalar value.
}
}

\examples{
# add interactive bar -------
library(ggplot2)
library(ggiraph)

p <- ggplot(mpg, aes(x = class, tooltip = class, data_id = class)) +
  geom_bar_interactive()

x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

dat <- data.frame(
  name = c("David", "Constance", "Leonie"),
  gender = c("Male", "Female", "Female"),
  height = c(172, 159, 71)
)
p <- ggplot(dat, aes(x = name, y = height, tooltip = gender, data_id = name)) +
  geom_col_interactive()

x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}

# an example with interactive guide ----
dat <- data.frame(
  name = c("Guy", "Ginette", "David", "Cedric", "Frederic"),
  gender = c("Male", "Female", "Male", "Male", "Male"),
  height = c(169, 160, 171, 172, 171)
)
p <- ggplot(dat, aes(x = name, y = height, fill = gender, data_id = name)) +
  geom_bar_interactive(stat = "identity") +
  scale_fill_manual_interactive(
    values = c(Male = "#0072B2", Female = "#009E73"),
    data_id = c(Female = "Female", Male = "Male"),
    tooltip = c(Male = "Male", Female = "Female")
  )
x <- girafe(ggobj = p)
if (interactive()) {
  print(x)
}
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
