% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guides.R
\name{guides_shape_grey}
\alias{guides_shape_grey}
\alias{guides_linewidth_grey}
\alias{guides_size_grey}
\title{Guides for legend element colour}
\usage{
guides_shape_grey(colour = grey, ...)

guides_linewidth_grey(colour = grey, ...)

guides_size_grey(colour = grey, ...)
}
\arguments{
\item{colour}{A default hex code to override the colour of the legend elements. Note, the "fill" inherits from this argument.  Defaults to grey.}

\item{...}{Other arguments passed to \code{\link[ggplot2:guide_legend]{ggplot2::guide_legend()}}.}
}
\value{
A ggplot guides.
}
\description{
Guides to over-ride legend elements with a grey colour
\itemize{
\item \code{guides_shape_grey()} for shape
\item \code{guides_linewidth_grey()} for linewidth
\item \code{guides_size_grey()} for size.
}
}
\examples{
library(dplyr)
library(tidyr)
library(ggplot2)
library(palmerpenguins)

set_blanket()

penguins |>
  drop_na() |>
  gg_jitter(
    x = species,
    y = flipper_length_mm,
    col = island,
    mapping = aes(shape = sex),
  ) +
  guides_shape_grey()

}
