% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-visualization.R
\name{create_interactive_map}
\alias{create_interactive_map}
\title{Create interactive map using leaflet (if available)}
\usage{
create_interactive_map(
  spatial_data,
  fill_variable = NULL,
  popup_vars = NULL,
  basemap = "terrain",
  color_scheme = "viridis",
  title = "Interactive Map",
  verbose = FALSE
)
}
\arguments{
\item{spatial_data}{Spatial data to map (sf object)}

\item{fill_variable}{Variable for coloring/filling}

\item{popup_vars}{Variables to show in popups}

\item{basemap}{Basemap type: "terrain", "satellite", "osm", "light"}

\item{color_scheme}{Color scheme for continuous variables}

\item{title}{Map title}

\item{verbose}{Print progress messages}
}
\value{
leaflet map object or NULL if leaflet unavailable
}
\description{
Create interactive maps with leaflet integration when available.
Falls back gracefully when leaflet is not installed.
}
\examples{
\dontrun{
# These examples demonstrate workflows with user's own spatial data
# Simple interactive point map
map <- create_interactive_map(study_sites, fill_variable = "ndvi_mean")

# Polygon map with custom basemap
map <- create_interactive_map(counties, fill_variable = "population",
                             basemap = "satellite")
}

}
