% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attributes.R
\name{get_attributes}
\alias{get_attributes}
\title{Get available attributes to filter species}
\usage{
get_attributes(data, attribute)
}
\arguments{
\item{data}{(data.frame) a data.frame imported with the
\code{\link{load_florabr}} function or a data.frame generated with the
\code{\link{select_species}} function.}

\item{attribute}{(character) the type of characteristic. Accept more than one
option. See detail to see the options.}
}
\value{
a list of data.frames with the available options to use in the
\code{\link{select_species}} function.
}
\description{
This function displays all the options available to filter species by its
characteristics
}
\details{
The attribute argument accepts the following options: kingdom, group,
subgroup, phylum, class, order, family, lifeform, habitat, vegetation,
origin, endemism, biome, states, taxonomicstatus or nomenclaturalstatus.
These options represent different characteristics of species that can be used
for filtering.
}
\examples{
data("bf_data") #Load Flora e Funga do Brasil data
# Get available biomes, life forms and states to filter species
d <- get_attributes(data = bf_data,
                    attribute = c("biome", "lifeform", "states"))
}
\references{
Flora e Funga do Brasil. Jardim Botânico do Rio de Janeiro. Available at:
http://floradobrasil.jbrj.gov.br/
}
