#' Timeseries of temperatures for nests
#' @title Timeseries of temperatures for nests
#' @author Marc Girondot \email{marc.girondot@@universite-paris-saclay.fr}
#' @docType data
#' @name nest
#' @description Timeseries of temperatures for nests
#' @references Girondot, M. & Kaska, Y. 2014. A model to predict the thermal 
#'          reaction norm for the embryo growth rate from field data. Journal of
#'          Thermal Biology. 45, 96-102.
#' @keywords datasets
#' @usage nest
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' data(nest)
#' }
#' @format A dataframe with raw data
NULL
