% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools-def.R
\name{tool_annotations}
\alias{tool_annotations}
\title{Tool annotations}
\usage{
tool_annotations(
  title = NULL,
  read_only_hint = NULL,
  open_world_hint = NULL,
  idempotent_hint = NULL,
  destructive_hint = NULL,
  ...
)
}
\arguments{
\item{title}{A human-readable title for the tool.}

\item{read_only_hint}{If \code{TRUE}, the tool does not modify its environment.}

\item{open_world_hint}{If \code{TRUE}, the tool may interact with an "open world"
of external entities. If \code{FALSE}, the tool's domain of interaction is
closed. For example, the world of a web search tool is open, but the world
of a memory tool is not.}

\item{idempotent_hint}{If \code{TRUE}, calling the tool repeatedly with the same
arguments will have no additional effect on its environment. (Only
meaningful when \code{read_only_hint} is \code{FALSE}.)}

\item{destructive_hint}{If \code{TRUE}, the tool may perform destructive updates
to its environment, otherwise it only performs additive updates. (Only
meaningful when \code{read_only_hint} is \code{FALSE}.)}

\item{...}{Additional named parameters to include in the tool annotations.}
}
\value{
A list of tool annotations.
}
\description{
Tool annotations are additional properties that, when passed to the
\code{.annotations} argument of \code{\link[=tool]{tool()}}, provide additional information about the
tool and its behavior. This information can be used for display to users, for
example in a Shiny app or another user interface.

The annotations in \code{tool_annotations()} are drawn from the \href{https://modelcontextprotocol.io/introduction}{Model Context Protocol} and are considered
\emph{hints}. Tool authors should use these annotations to communicate tool
properties, but users should note that these annotations are not guaranteed.
}
\examples{
# See ?tool() for a full example using this function.
# We're creating a tool around R's `rnorm()` function to allow the chatbot to
# generate random numbers from a normal distribution.
tool_rnorm <- tool(
  rnorm,
  # Describe the tool function to the LLM
  .description = "Drawn numbers from a random normal distribution",
  # Describe the parameters used by the tool function
  n = type_integer("The number of observations. Must be a positive integer."),
  mean = type_number("The mean value of the distribution."),
  sd = type_number("The standard deviation of the distribution. Must be a non-negative number."),
  # Tool annotations optionally provide additional context to the LLM
  .annotations = tool_annotations(
    title = "Draw Random Normal Numbers",
    read_only_hint = TRUE, # the tool does not modify any state
    open_world_hint = FALSE # the tool does not interact with the outside world
  )
)

}
\seealso{
Other tool calling helpers: 
\code{\link{tool}()},
\code{\link{tool_reject}()}
}
\concept{tool calling helpers}
