% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-any.R
\name{chat}
\alias{chat}
\title{Chat with any provider}
\usage{
chat(
  name,
  ...,
  system_prompt = NULL,
  params = NULL,
  echo = c("none", "output", "all")
)
}
\arguments{
\item{name}{Provider (and optionally model) name in the form
\code{"provider/model"} or \code{"provider"} (which will use the default model
for that provider).}

\item{...}{Arguments passed to the provider function.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\description{
This is a generic interface to all the other \code{chat_} functions that allow
to you pick the provider and the model with a simple string.
}
