% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTransfoCompRisks.R
\name{cr.lik}
\alias{cr.lik}
\title{Competing risk likelihood function.}
\usage{
cr.lik(
  n,
  s,
  Y,
  admin,
  cens.inds,
  M,
  Sigma,
  beta.mat,
  sigma.vct,
  rho.mat,
  theta.vct
)
}
\arguments{
\item{n}{The sample size.}

\item{s}{The number of competing risks.}

\item{Y}{The observed times.}

\item{admin}{Boolean value indicating whether or not administrative censoring
should be taken into account.}

\item{cens.inds}{matrix of censoring indicators (each row corresponds to a
single observation).}

\item{M}{Design matrix, consisting of [intercept, exo.cov, Z, cf]. Note that
\code{cf} represents the multiple ways of 'handling' the endogenous covariate
Z, see also the documentation of 'estimate.cmprsk.R'. When there is no
confounding, \code{M} will be [intercept, exo.cov].}

\item{Sigma}{The covariance matrix.}

\item{beta.mat}{Matrix containing all of the covariate effects.}

\item{sigma.vct}{Vector of standard deviations. Should be equal to
\code{sqrt(diag(Sigma))}.}

\item{rho.mat}{The correlation matrix.}

\item{theta.vct}{Vector containing the parameters of the Yeo-Johnsontrans-
formations.}
}
\value{
Evaluation of the log-likelihood function
}
\description{
This function implements the second step likelihood function of
the competing risk model defined in Willems et al. (2024+).
}
\references{
Willems et al. (2024+). Flexible control function approach under competing risks (in preparation).
}
