% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_check_field.R
\name{dp_check_field}
\alias{dp_check_field}
\title{Check if a vector is valid given a field descriptor}
\usage{
dp_check_field(
  x,
  fielddescriptor,
  constraints = TRUE,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x}{vector to test}

\item{fielddescriptor}{field descriptor to test the vector against}

\item{constraints}{also check relevant constraints in the field descriptor.}

\item{tolerance}{numerical tolerance used in some of the tests}
}
\value{
Returns \code{TRUE} when the field is valid. Returns a character vector with
length >= 1 if the field is not valid. The text in the character values 
indicates why the field is not valid.
}
\description{
Check if a vector is valid given a field descriptor
}
\seealso{
Use \code{\link{isTRUE}} to check if the test was successful. 
See \code{\link{dp_check_dataresource}} for a function that checks a complete data set.
}
