% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_track}
\alias{plot_track}
\title{Plot a Trajectory in Euclidean Space}
\usage{
plot_track(traj = NULL, x_coord = NULL, y_coord = NULL)
}
\arguments{
\item{traj}{\link[base]{data.frame} containing the trajectory produced by e.g.
\code{\link{traj_sim}()}. It must contain
 the columns \code{traj$pos_x} and \code{traj$pos_y}. It is also possible to specify a
 \link[base]{list} of such data.frames containing multiple trajectories.}

\item{x_coord}{(alternatively) \link[base]{numeric} \link[base]{vector} of x-coordinates or
a \link[base]{list} of x-coordinate vectors of multiple trajectories.}

\item{y_coord}{(alternatively) \link[base]{numeric} \link[base]{vector} of y-coordinates or
a \link[base]{list} of y-coordinate vectors of multiple trajectories.}
}
\value{
A '\code{\link[ggplot2]{ggplot}}' object.
}
\description{
This function plots the locations of a trajectory or multiple trajectories.
}
\examples{
set.seed(123)
traj <- traj_sim(50,
  copula = cyl_quadsec(0.1),
  marginal_circ = list(name = "vonmises", coef  = list(0, 1)),
  marginal_lin = list(name = "weibull", coef = list(shape = 3))
)
plot1 <- plot_track(traj=traj)

x_coord <- list(runif(10),runif(20),runif(3))
y_coord <- list(runif(10),runif(20),runif(3))

plot2 <- plot_track(x_coord=x_coord, y_coord=y_coord)

}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{\link{plot_cop_scat}()},
\code{\link{plot_joint_circ}()}, \code{\link{plot_cop_surf}()}, \code{\link{plot_joint_scat}()}.
}
