% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{remove_metadata}
\alias{remove_metadata}
\title{Remove metadata from a YAML configuration file}
\usage{
remove_metadata(config_path, key)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{key}{The key for the metadata entry to be removed}
}
\value{
The updated configuration after removing the specified metadata
}
\description{
This function removes metadata from a YAML configuration file by deleting
the specified key from the metadata section of the file.
}
\examples{
# Read the YAML file
test_config <- system.file("config", "default_config.yml", package = "connector")
file.copy(test_config, "test_config.yaml")

# Add metadata
config <- add_metadata("test_config.yaml", "new_metadata", "new_value")

# Remove metadata
config <- remove_metadata("test_config.yaml", "new_metadata")

unlink("test_config.yaml")

}
