% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{compare}
\alias{compare}
\title{Compare Two Norm Models Visually}
\usage{
compare(
  model1,
  model2,
  percentiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  age = NULL,
  score = NULL,
  weights = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{model1}{First model object (distribution free or beta-binomial)}

\item{model2}{Second model object (distribution free or beta-binomial)}

\item{percentiles}{Vector with percentile scores, ranging from 0 to 1 (exclusive)}

\item{age}{Optional vector with manifest age or group values}

\item{score}{Optional vector with manifest raw score values}

\item{weights}{Optional vector with manifest weights}

\item{title}{Custom title for plot (optional)}

\item{subtitle}{Custom subtitle for plot (optional)}
}
\value{
A ggplot object showing the comparison of both models
}
\description{
This function creates a visualization comparing two norm models by displaying
their percentile curves. The first model is shown with solid lines, the second
with dashed lines. If age and score vectors are provided, manifest percentiles
are displayed as dots. The function works with both regular cnorm models and
beta-binomial models and allows comparison between different model types.
}
\examples{
\dontrun{
# Compare different types of models
model1 <- cnorm(group = elfe$group, raw = elfe$raw)
model2 <- cnorm.betabinomial(elfe$group, elfe$raw)
compare(model1, model2, age = elfe$group, score = elfe$raw)
}

}
\seealso{
Other plot: 
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
