% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{column}
\alias{column}
\title{Boostrap 4 column system}
\usage{
column(width, ..., offset = 0)
}
\arguments{
\item{width}{The grid width of the column (must be between 1 and 12.}

\item{...}{Elements to include within the column.}

\item{offset}{The number of columns to offset this column from the end of the previous column.}
}
\description{
This function overwrites that of Shiny since there
are differences between the Bootstrap 3 and Bootstrap 4 grid systems
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 ui <- bs4DashPage(
   navbar = bs4DashNavbar(),
   sidebar = dashboardSidebar(
     bs4SidebarMenu(
       bs4SidebarMenuItem(
         "Welcome!",
         tabName = "tab_welcome",
         icon = "home"
       )
     )
   ),
   
   body = bs4DashBody(
     bs4TabItems(
       bs4TabItem(
         tabName = "tab_welcome",
         fluidRow(
           column(
             width = 1,
             offset = 11,
             actionButton(
               "mybutton",label = "",icon = icon("circle-question")
             )
           )
           
         ),
         fluidRow(
           h2("Placeholder")
         )
       )
     )
   )
 )
 
 server <- function(input, output, session) {}
 shinyApp(ui = ui, server = server)
}
}
