% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repos.R
\name{db_repo_create}
\alias{db_repo_create}
\title{Create Repo}
\usage{
db_repo_create(
  url,
  provider,
  path,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{url}{URL of the Git repository to be linked.}

\item{provider}{Git provider. This field is case-insensitive. The available
Git providers are \code{gitHub}, \code{bitbucketCloud}, \code{gitLab}, \code{azureDevOpsServices},
\code{gitHubEnterprise}, \code{bitbucketServer} and \code{gitLabEnterpriseEdition.}}

\item{path}{Desired path for the repo in the workspace. Must be in the format
\verb{/Repos/\{folder\}/\{repo-name\}}.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Creates a repo in the workspace and links it to the remote Git repo specified.
}
\seealso{
Other Repos API: 
\code{\link{db_repo_delete}()},
\code{\link{db_repo_get}()},
\code{\link{db_repo_get_all}()},
\code{\link{db_repo_update}()}
}
\concept{Repos API}
