/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import OpenSourceExtensions.MersenneTwisterFast;
import bartMachine.Tools;
import bartMachine.bartMachine_b_hyperparams;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.random.RandomGenerator;
import java.util.random.RandomGeneratorFactory;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class StatToolbox {
    private static boolean USE_XOSHIRO = false;
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(System.nanoTime());
    private static final ThreadLocal<Object> R = ThreadLocal.withInitial(StatToolbox::createRng);
    public static final double ILLEGAL_FLAG = -9.99999999E8;

    private static long nextSeed() {
        long l = SEED_UNIQUIFIER.getAndAdd(-7046029254386353131L);
        l ^= System.nanoTime();
        return l ^= Thread.currentThread().threadId();
    }

    private static Object createRng() {
        long l = StatToolbox.nextSeed();
        if (USE_XOSHIRO) {
            return RandomGeneratorFactory.of("Xoshiro256PlusPlus").create(l);
        }
        return new MersenneTwisterFast(l);
    }

    public static void setUseXoshiro(boolean bl) {
        if (USE_XOSHIRO != bl) {
            USE_XOSHIRO = bl;
            R.remove();
        }
    }

    public static double sample_from_inv_gamma(double d, double d2) {
        return 1.0 / (d2 / 2.0) / bartMachine_b_hyperparams.samps_chi_sq_df_eq_nu_plus_n[(int)Math.floor(StatToolbox.rand() * (double)bartMachine_b_hyperparams.samps_chi_sq_df_eq_nu_plus_n_length)];
    }

    public static double sample_from_norm_dist(double d, double d2) {
        double d3;
        Object object = R.get();
        if (object instanceof RandomGenerator) {
            RandomGenerator randomGenerator = (RandomGenerator)object;
            d3 = randomGenerator.nextGaussian();
        } else {
            d3 = bartMachine_b_hyperparams.samps_std_normal[(int)Math.floor(StatToolbox.rand() * (double)bartMachine_b_hyperparams.samps_std_normal_length)];
        }
        return d + Math.sqrt(d2) * d3;
    }

    public static final double sample_average(double[] dArray) {
        return Tools.sum_array(dArray) / (double)dArray.length;
    }

    public static final double sample_average(DoubleArrayList doubleArrayList) {
        double d = 0.0;
        for (int i = 0; i < doubleArrayList.size(); ++i) {
            d += doubleArrayList.getDouble(i);
        }
        return d / (double)doubleArrayList.size();
    }

    public static final double sample_average(int[] nArray) {
        int n;
        VectorSpecies vectorSpecies = IntVector.SPECIES_PREFERRED;
        IntVector intVector = IntVector.zero((VectorSpecies)vectorSpecies);
        int n2 = vectorSpecies.loopBound(nArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            intVector = intVector.add((Vector)IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray, (int)n));
        }
        double d = intVector.reduceLanes(VectorOperators.ADD);
        while (n < nArray.length) {
            d += (double)nArray[n];
            ++n;
        }
        return d / (double)nArray.length;
    }

    public static double sample_median(double[] dArray) {
        int n = dArray.length;
        Arrays.sort(dArray);
        if (n % 2 == 0) {
            double d = dArray[n / 2];
            double d2 = dArray[n / 2 - 1];
            return (d + d2) / 2.0;
        }
        return dArray[(n - 1) / 2];
    }

    public static final double sample_standard_deviation(int[] nArray) {
        double d = StatToolbox.sample_average(nArray);
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            double d3 = (double)nArray[i] - d;
            d2 = Math.fma(d3, d3, d2);
        }
        return Math.sqrt(d2 / ((double)nArray.length - 1.0));
    }

    public static final double sample_standard_deviation(double[] dArray) {
        return Math.sqrt(StatToolbox.sample_variance(dArray));
    }

    public static final double sample_variance(double[] dArray) {
        return StatToolbox.sample_sum_sq_err(dArray) / ((double)dArray.length - 1.0);
    }

    public static final double sample_sum_sq_err(double[] dArray) {
        int n;
        double d = StatToolbox.sample_average(dArray);
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        DoubleVector doubleVector = DoubleVector.zero((VectorSpecies)vectorSpecies);
        DoubleVector doubleVector2 = DoubleVector.broadcast((VectorSpecies)vectorSpecies, (double)d);
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector3 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            DoubleVector doubleVector4 = doubleVector3.sub((Vector)doubleVector2);
            doubleVector = doubleVector4.fma((Vector)doubleVector4, (Vector)doubleVector);
        }
        double d2 = doubleVector.reduceLanes(VectorOperators.ADD);
        while (n < dArray.length) {
            double d3 = dArray[n] - d;
            d2 = Math.fma(d3, d3, d2);
            ++n;
        }
        return d2;
    }

    public static double sample_minimum(int[] nArray) {
        int n;
        VectorSpecies vectorSpecies = IntVector.SPECIES_PREFERRED;
        IntVector intVector = IntVector.broadcast((VectorSpecies)vectorSpecies, (int)Integer.MAX_VALUE);
        int n2 = vectorSpecies.loopBound(nArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            IntVector intVector2 = IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray, (int)n);
            intVector = intVector.min((Vector)intVector2);
        }
        int n3 = intVector.reduceLanes(VectorOperators.MIN);
        while (n < nArray.length) {
            if (nArray[n] < n3) {
                n3 = nArray[n];
            }
            ++n;
        }
        return n3;
    }

    public static double sample_maximum(int[] nArray) {
        int n;
        VectorSpecies vectorSpecies = IntVector.SPECIES_PREFERRED;
        IntVector intVector = IntVector.broadcast((VectorSpecies)vectorSpecies, (int)Integer.MIN_VALUE);
        int n2 = vectorSpecies.loopBound(nArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            IntVector intVector2 = IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray, (int)n);
            intVector = intVector.max((Vector)intVector2);
        }
        int n3 = intVector.reduceLanes(VectorOperators.MAX);
        while (n < nArray.length) {
            if (nArray[n] > n3) {
                n3 = nArray[n];
            }
            ++n;
        }
        return n3;
    }

    public static double sample_minimum(double[] dArray) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        DoubleVector doubleVector = DoubleVector.broadcast((VectorSpecies)vectorSpecies, (double)Double.MAX_VALUE);
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector = doubleVector.min((Vector)doubleVector2);
        }
        double d = doubleVector.reduceLanes(VectorOperators.MIN);
        while (n < dArray.length) {
            if (dArray[n] < d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double sample_maximum(double[] dArray) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        DoubleVector doubleVector = DoubleVector.broadcast((VectorSpecies)vectorSpecies, (double)Double.NEGATIVE_INFINITY);
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector = doubleVector.max((Vector)doubleVector2);
        }
        double d = doubleVector.reduceLanes(VectorOperators.MAX);
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static int FindMaxIndex(int[] nArray) {
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
            n = i;
        }
        return n;
    }

    public static int multinomial_sample(IntArrayList intArrayList, double[] dArray) {
        double d = StatToolbox.rand();
        double d2 = 0.0;
        int n = 0;
        if (d < dArray[0]) {
            return intArrayList.getInt(0);
        }
        while (!(d > (d2 += dArray[n])) || !(d < d2 + dArray[n + 1])) {
            ++n;
        }
        return intArrayList.getInt(n + 1);
    }

    public static void setSeed(long l) {
        Object object = R.get();
        if (object instanceof MersenneTwisterFast) {
            MersenneTwisterFast mersenneTwisterFast = (MersenneTwisterFast)object;
            mersenneTwisterFast.setSeed(l);
        } else if (object instanceof RandomGenerator) {
            RandomGenerator randomGenerator = (RandomGenerator)object;
            R.set(RandomGeneratorFactory.of("Xoshiro256PlusPlus").create(l));
        }
    }

    public static double rand() {
        Object object = R.get();
        if (object instanceof MersenneTwisterFast) {
            MersenneTwisterFast mersenneTwisterFast = (MersenneTwisterFast)object;
            return mersenneTwisterFast.nextDouble(false, false);
        }
        RandomGenerator randomGenerator = (RandomGenerator)object;
        double d = randomGenerator.nextDouble();
        while (d == 0.0 || d == 1.0) {
            d = randomGenerator.nextDouble();
        }
        return d;
    }

    public static int nextInt(int n) {
        Object object = R.get();
        if (object instanceof MersenneTwisterFast) {
            MersenneTwisterFast mersenneTwisterFast = (MersenneTwisterFast)object;
            return mersenneTwisterFast.nextInt(n);
        }
        return ((RandomGenerator)object).nextInt(n);
    }
}

