% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{impute_date_time}
\alias{impute_date_time}
\title{Impute Missing Values}
\usage{
impute_date_time(partial, target)
}
\arguments{
\item{partial}{A list of partial date/time components.

\describe{
\item{Default value}{none}
}}

\item{target}{A list of target values for imputation.

\describe{
\item{Default value}{none}
}}
}
\value{
A list of imputed date/time components.
}
\description{
Imputes missing values in partial date/time components using target values.
}
\examples{
# Impute missing values for date components
partial_date <- list(year = "2020", month = NA_character_, day = NA_character_)
target_date <- list(year = "2020", month = "01", day = "01")
imputed_date <- admiral:::impute_date_time(partial_date, target_date)
print(imputed_date)

# Impute missing values for datetime components
partial_datetime <- list(
  year = "2020", month = NA_character_, day = NA_character_,
  hour = "12", minute = NA_character_, second = NA_character_
)
target_datetime <- list(
  year = "2020", month = "01", day = "01",
  hour = "12", minute = "00", second = "00"
)
imputed_datetime <- admiral:::impute_date_time(
  partial_datetime, target_datetime
)
print(imputed_datetime)

# Impute missing values when some components are already present
partial_mixed <- list(year = "2020", month = "06", day = NA_character_)
target_mixed <- list(year = "2020", month = "01", day = "01")
imputed_mixed <- admiral:::impute_date_time(partial_mixed, target_mixed)
print(imputed_mixed)

}
\keyword{internal}
