% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/fov.R
\name{CreateFOV}
\alias{CreateFOV}
\alias{CreateFOV.Centroids}
\alias{CreateFOV.data.frame}
\alias{CreateFOV.list}
\alias{CreateFOV.Segmentation}
\title{Create Spatial Coordinates}
\usage{
CreateFOV(coords, ...)

\method{CreateFOV}{Centroids}(
  coords,
  molecules = NULL,
  assay = "Spatial",
  key = NULL,
  misc = NULL,
  name = NULL,
  ...
)

\method{CreateFOV}{data.frame}(
  coords,
  type = c("segmentation", "centroids"),
  nsides = Inf,
  radius = NULL,
  theta = 0L,
  molecules = NULL,
  assay = "Spatial",
  key = NULL,
  misc = NULL,
  name = NULL,
  ...
)

\method{CreateFOV}{list}(
  coords,
  molecules = NULL,
  assay = "Spatial",
  key = NULL,
  misc = NULL,
  ...
)

\method{CreateFOV}{Segmentation}(
  coords,
  molecules = NULL,
  assay = "Spatial",
  key = NULL,
  misc = NULL,
  name = NULL,
  ...
)
}
\arguments{
\item{coords}{Spatial coordinates}

\item{...}{Arguments passed to other methods}

\item{molecules}{A \code{\link[base]{data.frame}} with spatially-resolved
molecule information or a
\code{\link[SeuratObject:Molecules-class]{Molecules}} object}

\item{assay}{Name of associated assay}

\item{key}{Key for these spatial coordinates}

\item{misc}{A list of miscellaneous information to store with the object}

\item{name}{When \code{coords} is a \code{\link[base]{data.frame}},
\code{\link[SeuratObject:Centroids-class]{Centroids}}, or
\code{\link[SeuratObject:Segmentation-class]{Segmentation}}, name
to store coordinates as}

\item{type}{When providing a \code{\link[base]{data.frame}}, specify if
the coordinates represent a cell segmentation or voxel centroids}

\item{nsides}{The number of sides to represent cells/spots; pass
\code{\link[base]{Inf}} to plot as circles}

\item{radius}{Radius of shapes when plotting}

\item{theta}{Angle to adjust shapes when plotting}
}
\value{
A \code{\link{FOV}} object
}
\description{
Create Spatial Coordinates
}
\seealso{
\code{\link{FOV-class}}
}
\concept{spatial}
