% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVboundparametersM.R
\name{SVboundparametersM}
\alias{SVboundparametersM}
\title{Sensitivity parameters for the Smith and VanderWeele bound}
\usage{
SVboundparametersM(
  whichEst,
  Vval,
  Uval,
  Tcoef,
  Ycoef,
  Scoef,
  Mmodel,
  pY1_T1_S1,
  pY1_T0_S1
)
}
\arguments{
\item{whichEst}{Input string. Defining the causal estimand of interest.
Available options are as follows. (1) Relative risk in the total
population: "RR_tot", (2) Risk difference in the total population:
"RD_tot", (3) Relative risk in the subpopulation: "RR_sub", (4) Risk
difference in the subpopulation: "RD_sub".}

\item{Vval}{Input matrix. The first column is the values of the categories of
V. The second column is the probabilities of the categories of V. If V is
continuous, use a fine grid of values and probabilities.}

\item{Uval}{Input matrix. The first column is the values of the categories of
U. The second column is the probabilities of the categories of U. If U is
continuous, use a fine grid of values and probabilities.}

\item{Tcoef}{Input vector. Two numerical elements. The first element is the
intercept in the model for the treatment. The second element is the slope
in the model for the treatment.}

\item{Ycoef}{Input vector. Three numerical elements. The first element is the
intercept in the model for the outcome. The second element is the slope for
T in the model for the outcome. The third element is the slope for U in the
model for the outcome.}

\item{Scoef}{Input matrix. Numerical matrix of size K by 4, where K is the
number of selection variables. Each row is the coefficients for one
selection variable. The first column is the intercepts in the models for
the selection variables. The second column is the slopes for V in the
models for the selection variables. The third column is the slopes for U in
the models for the selection variables. The fourth column is the slopes for
T in the models for the selection variables.}

\item{Mmodel}{Input string. Defining the models for the variables in the M
structure. If "P", the probit model is used. If "L", the logit model is}

\item{pY1_T1_S1}{Input scalar. The observed probability P(Y=1|T=1,I_S=1).}

\item{pY1_T0_S1}{Input scalar. The observed probability P(Y=1|T=0,I_S=1).
used.}
}
\value{
A list containing the sensitivity parameters and an indicator if the
treatment has been reversed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
\code{SVboundparametersM()} has been deprecated and is replaced by
\code{sensitivityparametersM()}.

\code{SVboundparametersM()} returns a list with the sensitivity parameters and an
indicator if the bias is negative and the treatment coding is reversed for an
assumed model.
}
\references{
Smith, Louisa H., and Tyler J. VanderWeele. "Bounding bias due
to selection." Epidemiology (Cambridge, Mass.) 30.4 (2019): 509.

Zetterstrom, Stina and Waernbaum, Ingeborg. "Selection bias and multiple
inclusion criteria in observational studies" Epidemiologic Methods 11, no.
1 (2022): 20220108.
}
