% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence.R
\name{influence.SSN2}
\alias{influence.SSN2}
\alias{influence.ssn_lm}
\alias{influence.ssn_glm}
\title{Regression diagnostics}
\usage{
\method{influence}{ssn_lm}(model, ...)

\method{influence}{ssn_glm}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tibble with residuals (\code{.resid}), leverage values (\code{.hat}),
cook's distance (\code{.cooksd}), and standardized residuals (\code{.std.resid}).
}
\description{
Provides basic quantities which are used in forming
a wide variety of diagnostics for checking the quality of fitted model objects.
}
\details{
This function calls \code{\link[=residuals.SSN2]{residuals.SSN2()}}, \code{\link[=hatvalues.SSN2]{hatvalues.SSN2()}},
and \code{\link[=cooks.distance.SSN2]{cooks.distance.SSN2()}} and puts the results into a tibble. It is
primarily used when calling \code{\link[=augment.SSN2]{augment.SSN2()}}.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
influence(ssn_mod)
}
\seealso{
\code{\link[=augment.SSN2]{augment.SSN2()}} \code{\link[=cooks.distance.SSN2]{cooks.distance.SSN2()}} \code{\link[=hatvalues.SSN2]{hatvalues.SSN2()}} \code{\link[=residuals.SSN2]{residuals.SSN2()}}
}
