% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.PPPFunctionLink.R
\name{PPPSquareLink}
\alias{PPPSquareLink}
\title{PPPSquareLink}
\description{
Square link function. See also the PrePostProcessing documentation.
}
\details{
Square link function. The transform is x^2, and the sign(x)*sqrt(abs(x)) its
inverse.
}
\examples{
## Start with data
XY = SBCK::dataset_like_tas_pr(2000)
X0 = XY$X0
X1 = XY$X1
Y0 = XY$Y0

## Define the PPP method
ppp = PPPSquareLink$new( bc_method = CDFt , cols = 2 )

## And now the correction
## Bias correction
ppp$fit(Y0,X0,X1)
Z = ppp$predict(X1,X0)

}
\section{Super classes}{
\code{\link[SBCK:PrePostProcessing]{SBCK::PrePostProcessing}} -> \code{\link[SBCK:PPPFunctionLink]{SBCK::PPPFunctionLink}} -> \code{PPPSquareLink}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PPPSquareLink-new}{\code{PPPSquareLink$new()}}
\item \href{#method-PPPSquareLink-clone}{\code{PPPSquareLink$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="fit"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-fit'><code>SBCK::PrePostProcessing$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PrePostProcessing" data-id="predict"><a href='../../SBCK/html/PrePostProcessing.html#method-PrePostProcessing-predict'><code>SBCK::PrePostProcessing$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PPPFunctionLink" data-id="itransform"><a href='../../SBCK/html/PPPFunctionLink.html#method-PPPFunctionLink-itransform'><code>SBCK::PPPFunctionLink$itransform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="SBCK" data-topic="PPPFunctionLink" data-id="transform"><a href='../../SBCK/html/PPPFunctionLink.html#method-PPPFunctionLink-transform'><code>SBCK::PPPFunctionLink$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPSquareLink-new"></a>}}
\if{latex}{\out{\hypertarget{method-PPPSquareLink-new}{}}}
\subsection{Method \code{new()}}{
Create a new PPPSquareLink object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPSquareLink$new(cols = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{Columns to apply the link function}

\item{\code{...}}{Others arguments are passed to PrePostProcessing}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PPPSquareLink` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PPPSquareLink-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PPPSquareLink-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PPPSquareLink$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
