% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_phate.R
\name{riem.phate}
\alias{riem.phate}
\title{PHATE}
\usage{
riem.phate(riemobj, ndim = 2, geometry = c("intrinsic", "extrinsic"), ...)
}
\arguments{
\item{riemobj}{a S3 \code{"riemdata"} class for \eqn{N} manifold-valued data.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{geometry}{(case-insensitive) name of geometry; either geodesic (\code{"intrinsic"}) or embedded (\code{"extrinsic"}) geometry.}

\item{...}{extra parameters for \code{PHATE} including \describe{
\item{nbdk}{size of nearest neighborhood (default: 5).}
\item{alpha}{decay parameter for Gaussian kernel exponent (default: 2).}
\item{potential}{type of potential distance transformation; \code{"log"} or \code{"sqrt"} (default: \code{"log"}).}
}}
}
\value{
a named list containing \describe{
\item{embed}{an \eqn{(N\times ndim)} matrix whose rows are embedded observations.}
}
}
\description{
PHATE is a nonlinear manifold learning method that is specifically targeted at 
improving diffusion maps by incorporating data-adaptive kernel construction, 
detection of optimal time scale, and information-theoretic metric measures.
}
\examples{
\donttest{
#-------------------------------------------------------------------
#          Example on Sphere : a dataset with three types
#
# 10 perturbed data points near (1,0,0) on S^2 in R^3
# 10 perturbed data points near (0,1,0) on S^2 in R^3
# 10 perturbed data points near (0,0,1) on S^2 in R^3
#-------------------------------------------------------------------
## GENERATE DATA
mydata = list()
for (i in 1:10){
  tgt = c(1, stats::rnorm(2, sd=0.1))
  mydata[[i]] = tgt/sqrt(sum(tgt^2))
}
for (i in 11:20){
  tgt = c(rnorm(1,sd=0.1),1,rnorm(1,sd=0.1))
  mydata[[i]] = tgt/sqrt(sum(tgt^2))
}
for (i in 21:30){
  tgt = c(stats::rnorm(2, sd=0.1), 1)
  mydata[[i]] = tgt/sqrt(sum(tgt^2))
}
myriem = wrap.sphere(mydata)
mylabs = rep(c(1,2,3), each=10)

## PHATE EMBEDDING WITH LOG & SQRT POTENTIAL 
phate_log  = riem.phate(myriem, potential="log")$embed
phate_sqrt = riem.phate(myriem, potential="sqrt")$embed
embed_mds  = riem.mds(myriem)$embed

## VISUALIZE
opar = par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(embed_mds,  col=mylabs, pch=19, main="MDS" )
plot(phate_log,  col=mylabs, pch=19, main="PHATE+Log")
plot(phate_sqrt, col=mylabs, pch=19, main="PHATE+Sqrt")
par(opar)
}

}
\references{
\insertRef{moon_visualizing_2019}{Riemann}
}
\concept{visualization}
