% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INMF.R
\name{uinmf}
\alias{uinmf}
\title{Perform Mosaic Integrative Non-negative Matrix Factorization with Unshared
Features}
\usage{
uinmf(
  objectList,
  unsharedList,
  k = 20,
  lambda = 5,
  niter = 30,
  nCores = 2,
  verbose = FALSE
)
}
\arguments{
\item{objectList}{list of input datasets. List elements should all be of the
same class. Viable classes include: matrix, dgCMatrix,
\link{H5Mat}, \link{H5SpMat}.}

\item{unsharedList}{List of input unshared feature matrices, with the same
requirement as \code{objectList}.}

\item{k}{Integer. Inner dimensionality to factorize the datasets into.
Default \code{20}.}

\item{lambda}{Regularization parameter. Use one number for all datasets or a
vector to specify for each dataset. Larger values penalize dataset-specific
effects more strongly (i.e. alignment should increase as \code{lambda}
increases). Default \code{5}.}

\item{niter}{Integer. Total number of block coordinate descent iterations to
perform. Default \code{30}.}

\item{nCores}{The number of parallel tasks that will be spawned.
Default \code{2}.}

\item{verbose}{Logical scalar. Whether to show information and progress.
Default \code{FALSE}.}
}
\value{
A list of the following elements:
\itemize{
 \item{\code{H} - a list of result \eqn{H_i} matrices of size
 \eqn{n_i \times k}}
 \item{\code{V} - a list of result \eqn{V_i} matrices}
 \item{\code{W} - the result \eqn{W} matrix}
 \item{\code{U} - a list of result \eqn{A_i} matrices}
 \item{\code{objErr} - the final objective error value.}
}
}
\description{
Performs mosaic integrative non-negative matrix factorization (UINMF) (A.R.
Kriebel, 2022) to return factorized \eqn{H}, \eqn{W}, \eqn{V} and \eqn{U}
matrices. The objective function is stated as

\deqn{\arg\min_{H\ge0,W\ge0,V\ge0,U\ge0}\sum_{i}^{d}
||\begin{bmatrix}E_i \\ P_i \end{bmatrix} -
(\begin{bmatrix}W \\ 0 \end{bmatrix}+
\begin{bmatrix}V_i \\ U_i \end{bmatrix})Hi||^2_F+
\lambda_i\sum_{i}^{d}||\begin{bmatrix}V_i \\ U_i \end{bmatrix}H_i||_F^2}

where \eqn{E_i} is the input non-negative matrix of the \eqn{i}'th dataset,
\eqn{P_i} is the input non-negative matrix for the unshared features,
\eqn{d} is the total number of datasets. \eqn{E_i} is of size
\eqn{m \times n_i} for \eqn{m} shared features and \eqn{n_i} sample points,
\eqn{P_i} is of size \eqn{u_i \times n_i} for \eqn{u_i} unshared feaetures,
\eqn{H_i} is of size \eqn{k \times n_i}, \eqn{V_i} is of size
\eqn{m \times k}, \eqn{W} is of size \eqn{m \times k} and \eqn{U_i} is of
size \eqn{u_i \times k}.

Similar to \code{\link{inmf}}, \code{uinmf} also optimizes the objective with
ANLS algorithm.
}
\examples{
# Fake matrices representing unshared features of the given datasets
# Real-life use should have features that are not presented in the
# intersection of features of all datasets involved.
ctrl.unshared <- ctrl.sparse[1:10,]
stim.unshared <- stim.sparse[11:30,]
set.seed(1)
result <- uinmf(list(ctrl.sparse, stim.sparse),
                list(ctrl.unshared, stim.unshared), verbose = FALSE)
}
\references{
April R. Kriebel and Joshua D. Welch, UINMF performs mosaic
integration of single-cell multi-omic datasets using nonnegative matrix
factorization, Nat. Comm., 2022
}
\author{
Yichen Wang
}
