% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.cmpd.get.smiles.inchi.R
\name{rc.cmpd.get.smiles.inchi}
\alias{rc.cmpd.get.smiles.inchi}
\title{getSmilesInchi}
\usage{
rc.cmpd.get.smiles.inchi(
  ramclustObj = NULL,
  inchikey = NULL,
  ignore.stereo = TRUE
)
}
\arguments{
\item{ramclustObj}{ramclustR object to look up smiles and inchi for each inchikey (without a smiles/inchi). Must provide one of ramclustObj or inchikey.}

\item{inchikey}{character vector of inchikey strings.  Must provide one of ramclustObj or inchikey.}

\item{ignore.stereo}{logical.  default = TRUE. If the Pubchem databases does not have the full inchikey string, should we search by the first (non-stereo) block of the inchikey?  When true, returns the first pubchem match to the inchikey block one string.  If the full inchikey is present, that is used preferentially.}
}
\value{
returns a ramclustR object.  new vector of $smiles and $inchi with length equal to number of compounds.
}
\description{
use PubChem API to look up full smiles and inchi notation for each inchikey
}
\details{
The $inchikey slot is used to look up parameters from pubchem. PubChem CID, a pubchem URL, smiles (canonical) and inchi are returned.  if smiles and inchi slots are alread present (from MSFinder, for example) pubchem smiles and inchi are used to fill in missing values only, not replace.
}
\references{
Kim S, Thiessen PA, Bolton EE, Bryant SH. PUG-SOAP and PUG-REST: web services for programmatic access to chemical information in PubChem. Nucleic Acids Res. 2015;43(W1):W605-11.
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{inchi}
\concept{inchikey}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramclustR}
\concept{smiles}
