% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_ic_series_on_scores}
\alias{ml_ic_series_on_scores}
\title{Rank-IC series computed on score (rebalance) dates}
\usage{
ml_ic_series_on_scores(scores_dt, labels_dt, method = "spearman")
}
\arguments{
\item{scores_dt}{Scores table (wide).}

\item{labels_dt}{Labels table (wide).}

\item{method}{Correlation method; \code{"spearman"} (default) or \code{"pearson"}.}
}
\value{
A data frame/data.table with \code{Date} and IC values.
}
\description{
Wrapper around \code{ic_series()} that first filters scores to formation dates
using an internal filter that keeps rows where at least one score is finite.
}
\examples{
\dontrun{
ic <- ml_ic_series_on_scores(res_xgb$scores, Y, method = "spearman")
}
}
