% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{jointIDA_direct}
\alias{jointIDA_direct}
\title{Estimate  Total Causal Effects  of Joint Interventions}
\usage{
jointIDA_direct(datacsv, cause, effect, method = c("min", "max", "median"),
  pcmethod = "stable", alpha, num.cores = 1, mem.efficient = FALSE,
  technique = c("RRC", "MCD"))
}
\arguments{
\item{datacsv}{The dataset in the csv format with rows are samples and columns are the variables.}

\item{cause}{The number of integer positions of the intervention variables in the dataset.}

\item{effect}{the  integer position of the target variable in the dataset.}

\item{method}{the method of calculating the final effect from multiple possible effects, e.g. min, max, median}

\item{pcmethod}{Character string specifying the method of the PC algorithm, e.g. stable for stable-PC, and parallel for parallel-PC.}

\item{alpha}{significance level (number in (0; 1) for the conditional independence tests.}

\item{num.cores}{The numbers of cores CPU to run the algorithm}

\item{mem.efficient}{If TRUE, uses less amount of memory at any time point while running the algorithm}

\item{technique}{The character string specifying the technique that will be used to estimate the total joint causal effects in the pcalg package.
RRC for Recursive regression for causal effects
MCD for Modifying the Cholesky decomposition}
}
\value{
A matrix that shows the direct causal effects (minimum of all possible effects) of the (first) cause (columns) on the effects (rows)
}
\description{
This is the parallelised version of the jointIDA (stable) algorithm in the pcalg package.
}

