% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LHS.R
\name{LHS}
\alias{LHS}
\title{Calculate LHS (Leaf-Height-Seed) Strategy}
\usage{
LHS(data)
}
\arguments{
\item{data}{A data frame containing columns for SLA, Height, and SeedMass.}
}
\value{
A data frame with an additional column 'LHS_strategy' containing the calculated LHS strategy.
}
\description{
This function calculates the LHS strategy for plant species based on their SLA (Specific Leaf Area),
Height, and Seed Mass values.
}
\details{
The function calculates median values for SLA, Height, and SeedMass from the input data.
It then determines the LHS strategy for each species based on whether its trait values are
less than or equal to (S) or greater than (L) the median values.

The resulting strategy is a combination of three letters (S or L) representing Leaf (SLA),
Height, and Seed (SeedMass) respectively, separated by hyphens.
}
\examples{
data(PFF)
pff <- PFF[, c("SLA", "Height", "SeedMass")]
result <- LHS(pff)
head(result)

}
\references{
\enumerate{
\item Westoby, M. (1998). A leaf-height-seed (LHS) plant ecology strategy scheme. Plant and Soil, 199, 213–227. https://doi.org/10.1023/A:1004327224729
\item Yang, J., Wang, Z., Zheng, Y., & Pan, Y. (2022). Shifts in plant ecological strategies in remnant forest patches along urbanization gradients. Forest Ecology and Management, 524, 120540. https://doi.org/10.1016/j.foreco.2022.120540
}
}
