% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.modules.R
\name{module_net}
\alias{module_net}
\title{Generate a n-modules network}
\usage{
module_net(
  module_number = 3,
  n_node_in_module = 30,
  intra_module_density = 0.3,
  inter_module_density = 0.01
)
}
\arguments{
\item{module_number}{number of modules}

\item{n_node_in_module}{number of nodes in each modules}

\item{intra_module_density}{intra_module_density, recommend bigger than 20*inter_module_density, default:0.3}

\item{inter_module_density}{inter_module_density, default:0.01}
}
\value{
n-modules metanet
}
\description{
this is just a random generation method, the module number of result is not exactly the module_number, you can change the inter_module_density and intra_module_density to get the proper result.
}
\examples{
g1 <- module_net()
get_n(g1)
plot(g1, mark_module = TRUE)
plot(g1, coors = g_layout(g1, zoom2 = 20))
plot(g1, coors = g_layout_polyarc(g1, group = "module"))
plot(g1, coors = g_layout_polygon(g1, group = "module"))
}
\seealso{
Other module: 
\code{\link{filter_n_module}()},
\code{\link{get_community}()},
\code{\link{get_module}()},
\code{\link{get_module_eigen}()},
\code{\link{module_detect}()},
\code{\link{module_eigen}()},
\code{\link{summary_module}()},
\code{\link{to_module_net}()},
\code{\link{zp_analyse}()}
}
\concept{module}
