% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{AddAndCheckSBSClassInVCF}
\alias{AddAndCheckSBSClassInVCF}
\title{Add and check SBS class in an annotated VCF with the corresponding SBS
mutation matrix}
\usage{
AddAndCheckSBSClassInVCF(vcf, mat96, mat1536, mat192 = NULL, sample.id)
}
\arguments{
\item{vcf}{An in-memory VCF file annotated with sequence context and
transcript information by function \code{\link{AnnotateSBSVCF}}. It must
*not* contain indels and must *not* contain DBS (double base
substitutions), or triplet base substitutions etc., even if encoded as
neighboring SBS.}

\item{mat96}{The SBS96 mutation count matrix.}

\item{mat1536}{The SBS1536 mutation count matrix.}

\item{mat192}{The SBS192 mutation count matrix.}

\item{sample.id}{Usually the sample id, but defaults to "count".}
}
\value{
The original \code{vcf} with three additional columns
  \code{SBS96.class}, \code{SBS192.class} and \code{SBS1536.class} added.
}
\description{
Add and check SBS class in an annotated VCF with the corresponding SBS
mutation matrix
}
\keyword{internal}
