% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaAnalysisESpath.R
\name{metaAnalysisESpath}
\alias{metaAnalysisESpath}
\title{Performing Gene Set Enrichment Meta-analysis}
\usage{
metaAnalysisESpath(
  objectMApath = NULL,
  effectS = NULL,
  measure = c("limma", "SMD", "MD"),
  WithinVarCorrect = TRUE,
  typeMethod = c("REM", "FEM"),
  missAllow = 0.3,
  numData = length(objectMApath)
)
}
\arguments{
\item{objectMApath}{A list of list. Each list contains two elements.
The first element is the Gene Set matrix (gene sets in rows and samples in
columns) and the second element is a vector of zeros and ones that represents
the state of the different samples of the Gene Sets matrix.
0 represents one group (controls) and 1 represents the other group (cases).}

\item{effectS}{A list of two elements. The first element is a dataframe
with gene sets in rows and studies in columns.
Each component of the dataframe is the effect of a gene set in a study.
The second element of the list is also a dataframe
with the same structure, but in this case each component of the dataframe
represent the variance of the effect of a gene set in a study. This argument
should be only used in the case that objectMApath argument is null.}

\item{measure}{A character string that indicates the type of effect size to
be calculated. The options are "limma", "SMD" and "MD". The default value
is "limma". See details for more information.}

\item{WithinVarCorrect}{A logical value that indicates if the within variance
correction should be applied. The default value is TRUE. See details for more
information.}

\item{typeMethod}{A character that indicates the method to be performed.
See "Details"for more information}

\item{missAllow}{a number that indicates the maximum proportion of missing
values allowed in a sample. If the sample has more proportion of missing
values the sample will be eliminated. In the other case the missing values
will be imputed using the K-NN algorithm.}

\item{numData}{The minimum number of datasets in which a gene
must be contained to be included in the emta-analysis. 
By default, the gene must be contained in all the datasets. 
If the number entered exceeds the number of studies, the total number of 
studies will be considered."}
}
\value{
A dataframe with the meta-analysis results. For more information
see the package vignette.
}
\description{
It performs Gene Sets Enrichment meta-analysis by applying Effects size
combination methods
}
\details{
There are different ways to calculate the effect size of a gene set:
\enumerate{
 \item "MD": Raw Mean Difference (Borenstein, 2009)
 \item "SMD":  Standardized Mean Difference (Hedges, 1981)
 \item "limma": Standardized Mean Difference calculated from the
 t-statistics and degrees of freedom obtained by the limma package by
 applying the transformation of Rosenthal and Rosnow, 2008). Its calculation
 is similar to the one proposed by (Marot et al., 2009) but considering the
 transformation of (Rosenthal and Rosnow, 2008).
    }

The correction of the variance of the effect size is based on
Lin L, Aloe AM (2021) in which the variance is calculated from the
different estimators.

The meta-analysis methods that can be applied are:
\enumerate{
 \item "FEM": Fixed Effects model
 \item "REM": Random Effects model (Default).
    }
}
\examples{

data("simulatedData")
results <- metaAnalysisESpath(objectMApath = objectMApathSim,
    measure = "limma", typeMethod = "REM")

}
\references{
Toro-Domínguez D., Villatoro-García J.A.,
Martorell-Marugán J., Román-Montoya Y., Alarcón-Riquelme M.E.,
Carmona-Sáez P. (2020).
A survey of gene expression meta-analysis: methods and applications,
Briefings in Bioinformatics, bbaa019,
\doi{10.1093/bib/bbaa019}

Borenstein, M. (2009). Effect sizes for continuous data. In H. Cooper,
L. V. Hedges, & J. C. Valentine (Eds.),
The handbook of research synthesis and meta-analysis (2nd ed., pp. 221–235).
New York: Russell Sage Foundation.

Hedges, L. V. (1981). Distribution theory for Glass's estimator of effect
size and related estimators. Journal of Educational Statistics, 6(2),
107–128. \doi{10.2307/1164588}

Lin L, Aloe AM (2021). Evaluation of various estimators for standardized mean
difference in meta-analysis. Stat Med. 2021 Jan 30;40(2):403-426.
\doi{10.1002/sim.8781}

Marot, G., Foulley, J. L., Mayer, C. D., & Jaffrézic, F. (2009).
Moderated effect size and P-value combinations for microarray meta-analyses.
Bioinformatics. 2692-2699. \doi{10.1093/bioinformatics/btp444}

Rosenthal, R., & Rosnow, R. L. (2008). Essentials of behavioral research:
Methods and data analysis. McGraw-Hill.
}
\seealso{
\code{\link{calculateESpath}}
}
\author{
Juan Antonio Villatoro Garcia,
\email{juanantoniovillatorogarcia@gmail.com}
}
