% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3.R
\name{gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3}
\alias{gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3}
\title{A Canonical Dynamic Macroeconomic General Equilibrium Model in Sequential Form under the Wage Postpayment Assumption (see Torres, 2016)}
\usage{
gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3(
  alpha.firm = 1,
  es.prod.lab.firm = 1,
  beta.prod.firm = 0.35,
  depreciation.rate = 0.06,
  eis = 1,
  Gamma.beta = 0.97,
  es.prod.lab.consumer = 1,
  beta.prod.consumer = 0.4,
  gr = 0,
  ...
)
}
\arguments{
\item{alpha.firm}{a positive scalar, indicating the efficiency parameter of firm 1.}

\item{es.prod.lab.firm}{the elasticity of substitution between product and labor in the production function of firm 1.}

\item{beta.prod.firm}{the share parameter of the product in the production function of firm 1.}

\item{depreciation.rate}{the physical depreciation rate of capital stock of firm 1.}

\item{eis}{the elasticity of intertemporal substitution of the consumer.}

\item{Gamma.beta}{the subjective discount factor of the consumer.}

\item{es.prod.lab.consumer}{the elasticity of substitution between product and labor in the CES-type period utility function of the consumer.}

\item{beta.prod.consumer}{the share parameter of the product in the period utility function.}

\item{gr}{the growth rate of the labor supply.}

\item{...}{arguments to be passed to the function sdm2.}
}
\value{
A general equilibrium (see \code{\link{sdm2}}).
}
\description{
A canonical dynamic macroeconomic general equilibrium model in sequential form
under the wage postpayment assumption (see Torres, 2016, Table 2.1 and 2.2).
In this model, there are two firms and one consumer.
Under the wage postpayment assumption, the consumer actually consumes a kind of labor (that is, leisure)
and the products produced by this labor at the same time.
Firm 1 is a regular production firm.
Firm 2 can store labor from one period to the next period for consumption by the consumer.
}
\examples{
\donttest{
gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3()

####
eis <- 0.8
Gamma.beta <- 0.97
gr <- 0.03
ge <- gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3(
  es.prod.lab.firm = 0.8,
  eis = eis, Gamma.beta = Gamma.beta, es.prod.lab.consumer = 0.8,
  gr = gr
)

ge$p
ge$p[1] * (sserr(eis = eis, Gamma.beta = Gamma.beta, gr = gr, prepaid = TRUE) + 1)
ge$z
addmargins(ge$D, 2)
addmargins(ge$S, 2)
ge$S[1, 1] * (1 + gr)
}

}
\seealso{
\code{\link{gemCanonicalDynamicMacroeconomic_Timeline_2_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_TimeCircle_2_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_Sequential_3_2}}.
}
