\name{two_axes}
\alias{two_axes}
\title{Two Axes function for optimization problems}

\usage{
two_axes(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Two Axes function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Two Axes function at the input vector \code{x}.
}

\description{
The Two Axes function is a benchmark function used in optimization. It is characterized by two components with different scaling factors, making the optimization problem anisotropic. The function presents a challenge due to its structure, with two regions requiring different search strategies for optimal convergence.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
two_axes(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
two_axes(x)

# Contour Plot: Visualizing the Two Axes Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) two_axes(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Two Axes Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = two_axes, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) two_axes(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Two Axes Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
{Hansen, N., & Ostermeier, A. (2001). \emph{Completely derandomized self-adaptation in evolution strategies}. Evolutionary Computation, 9(2), 159-195.}
}
