% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPI.R
\name{S3method.network}
\alias{S3method.network}
\alias{print.cor.net}
\alias{print.dag.net}
\title{[S3 methods] for \code{\link[=cor_network]{cor_network()}} and \code{\link[=dag_network]{dag_network()}}.}
\usage{
\method{print}{cor.net}(x, file = NULL, width = 6, height = 4, dpi = 500, ...)

\method{print}{dag.net}(
  x,
  file = NULL,
  width = 6,
  height = 4,
  dpi = 500,
  algorithm = names(x),
  ...
)
}
\arguments{
\item{x}{Object (class \code{cor.net} or \code{dag.net}) returned from \code{\link[=cor_network]{cor_network()}} or \code{\link[=dag_network]{dag_network()}}.}

\item{file}{File name of saved plot (\code{".png"} or \code{".pdf"}).}

\item{width, height}{Width and height (in inches) of saved plot.
Defaults to \code{6} and \code{4}.}

\item{dpi}{Dots per inch (figure resolution). Defaults to \code{500}.}

\item{...}{Other arguments (currently not used).}

\item{algorithm}{[For \code{dag.net}] Algorithm(s) to display.
Defaults to plot the final integrated DAG from BN results for each algorithm in \code{x}.}
}
\value{
Invisibly return a \code{\link[cowplot:as_grob]{grob}} object ("Grid Graphical Object", or a list of them) that can be further reused in \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} and \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}.
}
\description{
\describe{
\item{\code{print(cor.net)}}{
Plot (partial) correlation network results.
}
\item{\code{print(dag.net)}}{
Plot Bayesian network (DAG) results.
}
}
}
\keyword{internal}
