% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_forest.list}
\alias{plot_forest.list}
\title{plot_forest.list}
\usage{
plot_forest.list(
  lst_models,
  title = "Hazard Ratio",
  cpositions = c(0.02, 0.22, 0.4),
  fontsize = 0.7,
  refLabel = "reference",
  noDigits = 2
)
}
\arguments{
\item{lst_models}{List of Coxmos models.}

\item{title}{Character. Forest plot title (default: "Hazard Ratio").}

\item{cpositions}{Numeric vector. Relative positions of first three columns in the OX scale
(default: c(0.02, 0.22, 0.4)).}

\item{fontsize}{Numeric. Elative size of annotations in the plot (default: 0.7).}

\item{refLabel}{Character. Label for reference levels of factor variables (default: "reference").}

\item{noDigits}{Numeric. Number of digits for estimates and p-values in the plot (default: 2).}
}
\value{
A ggplot object per model representing the forest plot. The plot visualizes the hazard ratios and
their confidence intervals for each variable or component from the Coxmos model.
}
\description{
Run the function "plot_forest" for a list of models. More information in "?plot_forest".
}
\examples{
data("X_proteomic")
data("Y_proteomic")
X <- X_proteomic[,1:50]
Y <- Y_proteomic
splsicox.model <- splsicox(X, Y, n.comp = 2, penalty = 0.5, x.center = TRUE, x.scale = TRUE)
splsdrcox.model <- splsdrcox_penalty(X, Y, n.comp = 2, penalty = 0.5,
x.center = TRUE, x.scale = TRUE)
lst_models = list("sPLSICOX" = splsicox.model, "sPLSDRCOX" = splsdrcox.model)
plot_forest.list(lst_models)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
