% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_func_GLM.R
\name{F_func_GLM}
\alias{F_func_GLM}
\title{Fisher information matrix of generalized linear model (GLM)}
\usage{
F_func_GLM(w, beta, X, link = "logit")
}
\arguments{
\item{w}{allocation (can be exact or approximate)}

\item{beta}{GLM model covariate coefficient}

\item{X}{model matrix}

\item{link}{link function, default"logit", choose from "logit", "cloglog", "loglog", "probit", and "identity"(for regular linear regression)}
}
\value{
object of class "matrix_output", Fisher information matrix given X and model parameter beta
}
\description{
Fisher information matrix of generalized linear model (GLM)
}
\examples{
w = c(1/3,1/3, 1/3)
beta = c(0.5, 0.5, 0.5)
X = matrix(data=c(1,-1,-1,1,-1,1,1,1,-1), byrow=TRUE, nrow=3)
F_func_GLM(w=w, beta=beta, X=X, link='logit')

}
